/*------------------------------------------------------------------------------*
 * File Name: ThemeApply.c														*
 * Creation: CPY 1/27/03														*
 * Purpose: Origin C support for a Theme Gallery and Apply dialog				*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON										*
 *	CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS									*
 *	CPY 4/30/03 ADD_UNDO_APPLY													*				
 *	RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS						*
 *	CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW										*
 *	CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT							*
 *	CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1						*
 *  Danice 8/11/04 QA70-6638 v8.0114 MARK_SYSTEM_THEME_WITH_NAME_AND_PATH		*
 *  SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *	DSC 2/16/05 GET_ORIGIN_PATH													*
 *	DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE										*
 *	DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME						*
 *	Jasmine 02/15/06 ADD_TYPE_TAB												*
 *  Joseph 8/02/06  ADD_THEME_TO_CORRECT_FOLDER                                 *
 *  Joseph 8/08/06  ADD_ANALYSIS_THEME_TO_TAB                                   *
 *  Joseph 9/05/06  LET_FUNCTION_NAME_SORT										*
 *	Joseph 9/05/06  DISABLE_APPLY_THEME											*
 *  Joseph 10/25/06 HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB							*
 *  Joseph 11/08/06  CLEAR_ROW_CONTENT											*
 *	Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS								*
 *	Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS										*
 *	Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE							    *
 *	Jasmine 07/20/07 NAME_COL_WAS_HIDDEN										*
 *	Folger 08/31/07 EXCLUDE_LAST_USED_THEME										*
 *	Jasmine 09/07/07 QA70-10355 NOT_APPLY_THEME_TO_REPORT_SHEET					*
 *	Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME						*
 *	Jasmine 09/29/07 QA70-7416 FIX_RENAME_ANALYSIS_THEME_BUG					*
 *	Sim 10-10-2007 FIX_THEME_NAME_ASSIGNED_ERROR								*
 *	AW 10/21/07 MORE_ON_LOCALIZATION											*
 *	Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE									*
 *	Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_DELTE_THEME						*
 *	Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME				*
 *	Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER					*
 *	EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME						*
 *	Jasmine 08/19/09 CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY					*
 *	Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH			*
 *	Jasmine QA81-14829 SELECT_CORRESPONDING_THEME								*
 *	Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME		*
 *	Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
//#include <Project.h>
//#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
//#include <utilities.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///	#include "ResizeDialog.h"
///	#include <vsFlexGrid.h>
///	#include "theme_utils.h"
///	#include "Odlg.h"
///	#include "HelpID.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

#pragma labtalk(0) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

#include "GridControl.h"

#define _CAT "Theme"

//#define _DBINT(_STR, _INT)	//out_int(_STR, _INT);
//#define _DBSTR(_STR)		//out_str(_STR);
//#define _DBPRINTF(_FMT, _ARG)	//printf(_FMT, _ARG);

//putting ';' in front of labtalk to make the execution delayed, so it will be executed after
//event has been handled, which is safer
#define STR_THEME_REMINDER_MSG_RENAME	";type -M ThemeHowToRename"
#define STR_THEME_REMINDER_MSG_DEL		";type -M ThemeFolderOfDel"


// the following is the col arrangement, so the str and the enum must be consistent
//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
//#define STR_THEME_GRID_COLS "System|Location|Contents|Name"
//#define STR_THEME_GRID_COLS "System|Name|Size|Date|Path" //CPY 4/25/03 ADD_FILE_DATE added date column
//#define STR_THEME_GRID_COLS _LC("System|Name|Size|Date|Path", _CAT) ///AW 10/21/07 MORE_ON_LOCALIZATION
#define STR_THEME_GRID_COLS _LC("System|Name|Size|Path|Date", _CAT)	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH 
//---
//#define STR_ANALYSIS_THEME_GRID_COLS "System|Menu|Name|Function|Category|Scope|Size|Date|Path" ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//#define STR_ANALYSIS_THEME_GRID_COLS _LC("System|Menu|Name|Function|Category|Scope|Size|Date|Path", _CAT) ///AW 10/21/07 MORE_ON_LOCALIZATION
#define STR_ANALYSIS_THEME_GRID_COLS _LC("System|Menu|Name|Function|Category|Scope|Size|Path|Date", _CAT)	///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
enum {
	GRID_COL_IS_SYSTEM,
	GRID_COL_NAME,
	//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
	//GRID_COL_EDIT,
	GRID_COL_SIZE,
	//---
	GRID_COL_LOCATION,
	GRID_COL_DATE,	//CPY 4/25/03 ADD_FILE_DATE
	GRID_COL_TOTAL
};
///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
enum {
	ANALYSIS_GRID_COL_IS_SYSTEM,
	ANALYSIS_GRID_COL_MENU,
	ANALYSIS_GRID_COL_NAME,
	ANALYSIS_GRID_COL_FUNCTION,
	ANALYSIS_GRID_COL_CATEGORY,
	ANALYSIS_GRID_COL_SCOPE,
	ANALYSIS_GRID_COL_SIZE,
	ANALYSIS_GRID_COL_PATH,
	ANALYSIS_GRID_COL_DATE,
	ANALYSIS_GRID_COL_TOTAL
};

//enum {THEME_GRAPH_TAB, THEME_WORKSHEET_TAB};///Jasmine 02/15/06 ADD_TYPE_TAB 
  enum {THEME_GRAPH_TAB, THEME_WORKSHEET_TAB, THEME_ANALYSIS_TAB};
///End ADD_ANALYSIS_THEME_TO_TAB
#define NUM_DATA_PTS 20

//////////////////////////////////////////////////////////
/////////// Tooltips  ////////////////////////////////////
//////////////////////////////////////////////////////////
static string get_gw_col_heading_tooltips(int nCol) //graph and worksheet ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
{
	string strTemp;
	switch(nCol)
	{
	case GRID_COL_IS_SYSTEM:
		//strTemp = "Click to check one of the theme to become a System Theme";
		break;
	case GRID_COL_SIZE:
		strTemp = _L("Size = total number of properties, click to sort");
		break;
	case GRID_COL_NAME:
		strTemp = _L("double-click a Theme's name to rename");
		break;
	case GRID_COL_DATE:
		strTemp = _L("Last time a Theme file was modified, click to sort");
		break;
	case GRID_COL_LOCATION:
		strTemp = _L("Theme files are stored in Origin's system folder or in user's Origin folder");
		break;		
	}
	return strTemp;
}
///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
static string get_analysis_col_heading_tooltips(int nCol) //graph and worksheet 
{
	string strTemp;
	switch(nCol)
	{
	case ANALYSIS_GRID_COL_IS_SYSTEM:
		//strTemp = "Click to check one of the theme to become a System Theme";
		break;
	case ANALYSIS_GRID_COL_MENU:
		strTemp = _L("Whether the theme will be shown on the menu");
		break;
	case ANALYSIS_GRID_COL_SIZE:
		strTemp = _L("Size = total number of properties, click to sort");
		break;
	case ANALYSIS_GRID_COL_FUNCTION:
		strTemp = _L("the name of the XFunction that the theme used");
		break;
	case ANALYSIS_GRID_COL_CATEGORY:
		strTemp = _L("The category that the theme belong to");
		break;
	case ANALYSIS_GRID_COL_SCOPE:
		strTemp = _L("the scope that the theme be used");
		break;
	case ANALYSIS_GRID_COL_NAME:
		strTemp = _L("double-click a Theme's name to rename");
		break;
	case ANALYSIS_GRID_COL_DATE:
		strTemp = _L("Last time a Theme file was modified, click to sort");
		break;
	case ANALYSIS_GRID_COL_PATH:
		strTemp = _L("Theme files are stored in Origin's system folder or in user's Origin folder");
		break;		
	}
	return strTemp;
}
///End ADD_ANALYSIS_THEME_TO_TAB

//////////////////////////////////////////////////////////
/////////// Theme Collection//////////////////////////////
//////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////
/////////// end	    //////////////////////////////////////
//////////////////////////////////////////////////////////

enum {THEME_ADD, THEME_SEPARATOR, 
THEME_EDIT, THEME_DELETE, 
	THEME_SEPARATOR1,
THEME_DUPLICATE, THEME_COMBINE, 
	THEME_SEPARATOR2, 
THEME_SET_SYSTEM, THEME_CLEAR_SYSTEM,
	THEME_SEPARATOR3,
THEME_SHOW_TOOLTIPS};

//--WAIT_FIX, cannot put into constructors
//bool bIsSystemTheme;
//bool bMultiSel = false;
//---
///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
//class ThemeListControlMenu : public Menu
//{
//public:
	//ThemeListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips) : Menu()
	//{
		//m_nChoice = -1;
		//Add(_L("Add &New"), OnMenuItem);
		//Add(NULL, OnMenuItem);
		//Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//Add(_L("&Delete"), OnMenuItem, bIsInThemeList? MF_ENABLED : MF_GRAYED);
		//Add(NULL, OnMenuItem);
		//Add(_L("D&uplicate"), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//
		//Add(NULL, OnMenuItem);
//
		//Add(_L("&Set as System Theme"), OnMenuItem, (bIsCanbeSystemTheme && bIsInThemeList && !bIsSystemTheme && !bMultiSel) ? MF_ENABLED : MF_GRAYED );
		//Add(_L("&Clear System Theme"), OnMenuItem, bHasSystemTheme? MF_ENABLED : MF_GRAYED );
		//
		//Add(NULL, OnMenuItem);
		//
		//Add(_L("Show &Tooltips"), OnMenuItem, bShowTips?MF_CHECKED : MF_UNCHECKED);
	//}
	//void OnMenuItem(UINT nPos)
	//{
		//m_nChoice = nPos;
	//}
	//bool GetCommand(int& nChoice)
	//{
		//if(m_nChoice >= THEME_ADD && m_nChoice <= THEME_SHOW_TOOLTIPS)
		//{
			//nChoice = m_nChoice;
			//return true;
		//}
		//return false;
	//}
//private:
	//int	m_nChoice;
//};
class ThemeListControlMenuBase : public Menu
{
public:
	void OnMenuItem(UINT nPos)
	{
		m_nChoice = nPos;
	}
	virtual bool GetCommand(int& nChoice){return false;}
	
protected:
	int	m_nChoice;	
};
class ThemeGWListControlMenu : public ThemeListControlMenuBase
{
public:
	///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	//ThemeGWListControlMenu(bool bEdit, bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
	ThemeGWListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
	///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
	{
		m_nChoice = -1;
		Add(_L("Add &New"), OnMenuItem);
		Add(NULL, OnMenuItem);
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		//Add(_L("&Edit..."), OnMenuItem, (bEdit && bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
		Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		Add(_L("&Delete"), OnMenuItem, bIsInThemeList? MF_ENABLED : MF_GRAYED);
		Add(NULL, OnMenuItem);
		Add(_L("D&uplicate"), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
		
		Add(NULL, OnMenuItem);

		Add(_L("&Set as System Theme"), OnMenuItem, (bIsCanbeSystemTheme && bIsInThemeList && !bIsSystemTheme && !bMultiSel) ? MF_ENABLED : MF_GRAYED );
		Add(_L("&Clear System Theme"), OnMenuItem, bHasSystemTheme? MF_ENABLED : MF_GRAYED );
		
		Add(NULL, OnMenuItem);
		
		Add(_L("Show &Tooltips"), OnMenuItem, bShowTips?MF_CHECKED : MF_UNCHECKED);
	}
	bool GetCommand(int& nChoice)
	{
		if(m_nChoice >= THEME_ADD && m_nChoice <= THEME_SHOW_TOOLTIPS)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
};

enum {
	//ANALYSIS_THEME_EDIT, 
	ANALYSIS_THEME_DELETE, 
	ANALYSIS_THEME_SEPARATOR1,
	ANALYSIS_THEME_DUPLICATE,
	//ANALYSIS_THEME_COMBINE,
	ANALYSIS_THEME_SEPARATOR2,
	ANALYSIS_THEME_SHOW_TOOLTIPS
};
	
class ThemeAnalysisListControlMenu : public ThemeListControlMenuBase
{
public:
	ThemeAnalysisListControlMenu(bool bIsSystemTheme, bool bHasSystemTheme, bool bIsInThemeList, bool bMultiSel, bool bIsCanbeSystemTheme, bool bShowTips)
	{
		m_nChoice = -1;
		//Add(_L("&Edit..."), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		Add(_L("&Delete"), OnMenuItem, bIsInThemeList? MF_ENABLED : MF_GRAYED);
		Add(NULL, OnMenuItem);
		Add(_L("D&uplicate"), OnMenuItem, (bIsInThemeList && !bMultiSel) ? MF_ENABLED : MF_GRAYED);
		//Add(_L("Com&bine"), OnMenuItem, (bIsInThemeList && bMultiSel) ? MF_ENABLED : MF_GRAYED);
		Add(NULL, OnMenuItem);
		
		Add(_L("Show &Tooltips"), OnMenuItem, bShowTips?MF_CHECKED : MF_UNCHECKED);
	}	
	
	bool GetCommand(int& nChoice)
	{
		//if(m_nChoice >= ANALYSIS_THEME_EDIT && m_nChoice <= ANALYSIS_THEME_SHOW_TOOLTIPS)
		if(m_nChoice >= ANALYSIS_THEME_DELETE && m_nChoice <= ANALYSIS_THEME_SHOW_TOOLTIPS)
		{
			nChoice = m_nChoice;
			return true;
		}
		return false;
	}
};

///End ADD_ANALYSIS_THEME_TO_TAB
///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
//typedef bool (* P_THEME_EDITOR)(LPCSTR lpcszThemeFilename, HWND hWndParent);
typedef bool (* P_THEME_EDITOR)(LPCSTR lpcszThemeFilename, HWND hWndParent, string* pstrEditingFile = NULL);
///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME

///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
class ThemeListControlBase : public GridListControl
{
public:
	void Init(int nID, Dialog& dlg)
	{	
		
		GridListControl::Init(nID, dlg);
		ClearAll();
		Reset();
		SetAlternateRowColors();
		///Joseph 11/08/06  CLEAR_ROW_CONTENT	
		//m_flx.Rows = 1;
		//m_flx.FixedRows = 1;
		///End CLEAR_ROW_CONTENT
		
		///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		//hidecolAndsetFormat();
		///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		m_flx.FixedCols = 0;//hide the Row heading

		m_flx.ExtendLastCol = true;
		m_flx.SelectionMode = flexSelectionListBox;
		m_flx.AllowUserResizing = flexResizeColumns;
		m_flx.AutoSizeMode = flexAutoSizeColWidth;
		m_flx.AllowSelection = true;
		m_flx.Editable = flexEDKbdMouse;
		// allow sorting
		m_flx.ExplorerBar = flexExSortShow;
	}
	
	virtual void Reset(){}
	
	int AddTheme(const string& str, int nType, bool bIsIncrementList)
	{
		int	nRow = m_flx.Rows;
		m_flx.AddItem(str);
		setAddCellFormat(nRow, nType, bIsIncrementList);
		return nRow;
	}
protected:
	virtual void hidecolAndsetFormat(){}
	virtual void setAddCellFormat(int nRow, int nType, bool bIsIncrementList){}
};
//class ThemeListControl : public GridListControl
//{
//public:
	//void Init(int nID, Dialog& dlg)
	//{
		//GridListControl::Init(nID, dlg);
		//Reset();
		//m_flx.ExtendLastCol = true;
		//m_flx.SelectionMode = flexSelectionListBox;
		//m_flx.AllowSelection = true;
		//m_flx.Editable = flexEDKbdMouse;
		//// allow sorting
		//m_flx.ExplorerBar = flexExSortShow;
		//
		////---- CPY 4/25/03 ADD_FILE_DATE
		//m_flx.ColFormat(GRID_COL_DATE) ="General Date"; //"Medium Date";
		//m_flx.ColDataType(GRID_COL_DATE) = flexDTDate;
		////----
		//
		//SetAlternateRowColors();
		//
		//HideCol(GRID_COL_IS_SYSTEM);
	//}
	//void Reset()
	//{
		////m_flx.FormatString = STR_THEME_GRID_COLS;
		//SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
		//m_flx.Rows = 1;
		//m_flx.FixedRows = 1;
		//m_flx.FixedCols = 0;//hide the Row heading
		//m_flx.Cols = GRID_COL_TOTAL;
	//}
		//
//
	//int AddTheme(const string& str, int nType, bool bIsIncrementList)
	//{
		//int	nRow = m_flx.Rows;
		//m_flx.AddItem(str);
		//SetCellData(nRow, GRID_COL_LOCATION, nType);
		//SetItalic(nRow, GRID_COL_NAME, bIsIncrementList);
		//return nRow;
	//}
//
//};

class ThemeGWListControl : public ThemeListControlBase //Graph and WorkSheet ListControl
{
public:
	void Reset()
	{
		///Joseph 11/08/06  CLEAR_ROW_CONTENT
		m_flx.Rows = 1;
		m_flx.FixedRows = 1;
		///End CLEAR_ROW_CONTENT
		m_flx.Cols = GRID_COL_TOTAL;

		///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
		hidecolAndsetFormat();
		///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	}
private:
	void hidecolAndsetFormat()
	{	
		SetColFormat(GRID_COL_DATE, "General Date"); //"Medium Date";
		SetColDataType(GRID_COL_DATE, flexDTDate);
		SetColDataType(GRID_COL_NAME, flexDTString);
		HideCol(-1, false);	///Jasmine 07/20/07 NAME_COL_WAS_HIDDEN, show all columns
		HideCol(GRID_COL_IS_SYSTEM);
		
		///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		//SetFormatStrLocal(STR_THEME_GRID_COLS, _CAT);
		///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	}
	void setAddCellFormat(int nRow, int nType, bool bIsIncrementList)
	{
		SetCellData(nRow, GRID_COL_LOCATION, nType);
		SetItalic(nRow, GRID_COL_NAME, bIsIncrementList);
	}
};

class ThemeAnalysisListControl : public ThemeListControlBase //Analysis ListControl
{
public:
	void Reset()
	{
		///Joseph 11/08/06  CLEAR_ROW_CONTENT
		m_flx.Rows = 1;
		m_flx.FixedRows = 1;
		///End CLEAR_ROW_CONTENT
		m_flx.Cols = ANALYSIS_GRID_COL_TOTAL;
		SetColDataType(ANALYSIS_GRID_COL_MENU, flexDTBoolean);
		
		///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		SetFormatStrLocal(STR_ANALYSIS_THEME_GRID_COLS, _CAT);
		hidecolAndsetFormat();
		///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	}
private:
	void hidecolAndsetFormat()
	{
		SetColDataType(ANALYSIS_GRID_COL_FUNCTION, flexDTString);  ///Joe 9/05/06  LET_FUNCTION_NAME_SORT
		SetColFormat(ANALYSIS_GRID_COL_DATE, "General Date"); //"Medium Date";
		SetColDataType(ANALYSIS_GRID_COL_DATE, flexDTDate);
		HideCol(-1, false);	///Jasmine 07/20/07 NAME_COL_WAS_HIDDEN, show all columns
		HideCol(ANALYSIS_GRID_COL_IS_SYSTEM);
		HideCol(ANALYSIS_GRID_COL_MENU);	///Joseph 05/05/07 	HIDE_THIS_CODE_TEMPORY
		///Jasmine 08/19/09 CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY
		HideCol(ANALYSIS_GRID_COL_CATEGORY);
		HideCol(ANALYSIS_GRID_COL_SCOPE);
		///End CATEGORY_AND_SCOPE_ARE_NOT_USED_CURRENTLY
		
		///Joseph 06/25/07 FIX_BUG_NAME_MESS_ON_TAB_CHANGE
		//SetFormatStrLocal(STR_ANALYSIS_THEME_GRID_COLS, _CAT); ///Jasmine 07/20/07 comment the duplicate code
		///End FIX_BUG_NAME_MESS_ON_TAB_CHANGE
	}
	void setAddCellFormat(int nRow, int nType, bool bIsIncrementList)
	{
		SetCellData(nRow, ANALYSIS_GRID_COL_PATH, nType);
		SetItalic(nRow, ANALYSIS_GRID_COL_NAME, bIsIncrementList);
	}
};
///End ADD_ANALYSIS_THEME_TO_TAB

class ThemeGalleryDlg : public ResizeDialog 
{
private:
	TabControl 			m_tabPage;///Jasmine 02/15/06 ADD_TYPE_TAB
	///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	ThemeGWListControl	m_themGWList; //Graph && Worksheet ThemeList;
	ThemeAnalysisListControl m_themAnalysisList; 
	///End  ADD_ANALYSIS_THEME_TO_TAB
	ComboBox m_cmbApplyTo;
	string	m_strWksName;
	string	m_strThemeFilename;
	bool	m_bExcludeIncremenTypes;
	int		m_nUndoStackCount;
	string	m_strOldStr;
	bool	m_bPreviewGraphReady;
	Control m_cntrlSystemTheme;
	bool	m_bCurrentPage;///Jasmine 02/15/06 ADD_TYPE_TAB
	int 	m_nPageType;
	int		m_nThemeType;
	bool	m_bExcludeLastUsed;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
public:
	ThemeGalleryDlg() : ResizeDialog(IDD_THEME_GALLERY80, "ODlg8") //IDD_THEME_GALLERY, "ODlg")///Jasmine 02/15/06 ADD_TYPE_TAB, separate from 75's resource
	{
		//-- get active page type
		Page pg = Project.Pages();		
		if(!pg)
			m_nPageType = EXIST_NONE;
		else
			m_nPageType = pg.GetType();
		
		m_nThemeType = theme_get_type_from_page_type(m_nPageType);///dsc 2/23/05
		
		m_bExcludeIncremenTypes = true;
		m_bExcludeLastUsed = true;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
		
		m_nUndoStackCount = 0;
		m_strOptionsSecName = "ThemeGallery";
		m_strOptionsValName = "Options";
	}
	int DoModalEx(HWND hWndParent = NULL)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hWndParent);
		
		return nRet;
	}
	int ShowTab(int nPageType)
	{
		int nSelTab;
		switch(nPageType)
		{
		case EXIST_WKS:
			nSelTab = THEME_WORKSHEET_TAB; break;
		case EXIST_PLOT:	
		default:
			nSelTab = THEME_GRAPH_TAB; break;	
		}
		m_tabPage.SetCurSel(nSelTab);  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		Control cntrl;
		OnTabChange(cntrl);
		return nSelTab;
	}
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)
	ON_SIZE(OnDlgResize)
	
	ON_CONTEXTMENU(OnShowMenu)

	ON_CBN_SELCHANGE(IDC_THEME_APPLY_TO, OnApplyToComboChange)

	//ON_SIZE(OnResize)
	ON_GRID_BEFORE_EDIT(IDC_THEME_GRID, OnBeforeEdit)
	ON_GRID_AFTER_EDIT(IDC_THEME_GRID, OnAfterEdit)
	//ON_GRID_AFTER_SEL_CHANGE(IDC_THEME_GRID, OnAfterSelChange)
	ON_GRID_SEL_CHANGE(IDC_THEME_GRID, OnSelChange)
	ON_GRID_MOUSE_MOVE(IDC_THEME_GRID, OnMouseMove)	//CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
	ON_GRID_BEFORE_MOUSE_DOWN(IDC_THEME_GRID, OnBeforeMouseDown)
	ON_GRID_DBLCLICK(IDC_THEME_GRID, OnDblClick)
	//--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
	//ON_GRID_BUTTON_CLICK(IDC_THEME_GRID, OnEditTheme)
	//---
	ON_BN_CLICKED(IDC_THEME_SHOW_GRAPH_ONLY, OnShowThemeTypes)
	ON_BN_CLICKED(IDC_THEME_APPLY, OnApplyButton)
	ON_BN_CLICKED(IDC_THEME_UNDO, OnUndoApplyButton) //CPY 4/30/03 ADD_UNDO_APPLY
	
	ON_TAB_SEL_CHANGE(IDC_THEME_TAB, OnTabChange)
	
EVENTS_END
	/////////////////////////////////////////////////
	// Event handling ///////////////////////////////
	/////////////////////////////////////////////////
	BOOL OnInitDialog()
	{
		waitCursor junk;
		ResizeDialog::OnInitDialog(IDC_THEME_GRID);
		
		load_options();
		
		m_cntrlSystemTheme = GetItem(IDC_THEME_CURRENT_SYSTEM);
		m_cmbApplyTo = GetItem(IDC_THEME_APPLY_TO);
		m_cmbApplyTo.SetCurSel(0);
		m_themGWList.Init(IDC_THEME_GRID, *this);  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		
		///Jasmine 02/15/06 ADD_TYPE_TAB
		m_tabPage = GetItem(IDC_THEME_TAB);
		m_tabPage.InsertItem(THEME_GRAPH_TAB, _L("Graph"));
		m_tabPage.InsertItem(THEME_WORKSHEET_TAB, _L("Worksheet"));
        ///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
        //change name
        //m_tabPage.InsertItem(THEME_ANALYSIS_TAB, "Analysis");  ///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		m_tabPage.InsertItem(THEME_ANALYSIS_TAB, _L("Dialog"));  
        ///End CLEAN_THEME_ORGANIZER
		ShowTab(m_nPageType);
		///End ADD_TYPE_TAB
		
		Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
		btnShowGraphTypes.Check = m_bExcludeIncremenTypes;
		
		//load_themes_to_grid(false, false);///Jasmine 02/15/06 ADD_TYPE_TAB
							
		Button btnApply = GetItem(IDC_THEME_APPLY);
		btnApply.Enable = false;
		
		//--- CPY 4/30/03 ADD_UNDO_APPLY
		undo_enabled(true, 0);
		//---
		
		//CPY 8/20/03
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
		return TRUE;
	}
	BOOL OnDestroy()
	{
		save_options();
		Worksheet wks(m_strWksName);
		if(wks)
			wks.Destroy();
		m_strWksName.Empty();
		
		if(m_strThemeFilename.IsFile())
			DeleteFile(m_strThemeFilename);
		m_strThemeFilename.Empty();
		
		//m_trThemes.Reset();
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		MoveControlsHelper	_temp(this);		///Jasmine 03/27/06 DLG_RESIZE_PAINT_MESS
		uint nCntrlsRight[] = {
			IDC_THEME_APPLY_GROUP,
			IDC_THEME_APPLY_TO,
			IDC_THEME_APPLY,
			IDC_THEME_UNDO,
			IDCANCEL,
			0};
		uint nCntrlsBottom[] = {
			IDC_THEME_SHOW_GRAPH_ONLY,
			0};
		///Jasmine 02/15/06 ADD_TYPE_TAB
		//ResizeMoveControlsRightBottom(IDC_THEME_GRID, nCntrlsRight, nCntrlsBottom, cx, cy);
		ResizeMoveControlsRightBottom(IDC_THEME_TAB, nCntrlsRight, nCntrlsBottom, cx, cy);
		//ArrangeMainItemAndControls(nCntrlsBottom, IDC_THEME_TAB, nCntrlsRight);
		RECT rTab;
		GetClientRect(m_tabPage, rTab);
        
        ///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
        //on tab change, resize the dlg
		int nEdge = GetControlGap();
		if( THEME_ANALYSIS_TAB == m_tabPage.GetCurSel())
		{
			rTab.right = cx - nEdge;
			MoveControl(m_tabPage, rTab);
		}
		///End  CLEAN_THEME_ORGANIZER       

		m_tabPage.AdjustRect(FALSE, &rTab);
		Control ctrlGrid=GetItem(IDC_THEME_GRID);
		ctrlGrid.MoveWindow(&rTab);
		///End ADD_TYPE_TAB
		
		///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
		Control ctrlClose = GetItem(IDCANCEL);
		GetClientRect(ctrlClose, rTab);
		int nButtonHeight = rTab.bottom - rTab.top;
		rTab.bottom = cy - nEdge;
		//---Jasmine 12/04/08 v8.0982b correct wrong resizing code
		//rTab.top = cy - nButtonHeight;
		rTab.top = rTab.bottom - nButtonHeight;
		//---end
		MoveControl(ctrlClose, rTab);
		///End  CLEAN_THEME_ORGANIZER
		
		return TRUE;
	}
	BOOL OnShowThemeTypes(Control cntrl)
	{
		Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
		//m_bExcludeIncremenTypes = btnShowGraphTypes.Check;
		int nSelTab = m_tabPage.GetCurSel();
		switch (nSelTab)
		{
		case THEME_GRAPH_TAB:
			m_bExcludeIncremenTypes = btnShowGraphTypes.Check;
			break;
		case THEME_ANALYSIS_TAB:
			m_bExcludeLastUsed = btnShowGraphTypes.Check;
			break;
		default:
			break;
		}
		//------ End EXCLUDE_LAST_USED_THEME
		load_themes_to_grid(true, false);
		return TRUE;
	}
	//////////////////////////
	// Add New Theme
	//////////////////////////
	BOOL OnAdd(Control cntrl)
	{
		string strFilename;
		///Joe  08/02/2006  ADD_THEME_TO_CORRECT_FOLDER
		if(!theme_get_next_file_name(strFilename,true, m_nThemeType))
		//if(!theme_get_next_file_name(strFilename))
		///End ADD_THEME_TO_CORRECT_FOLDER
			return false;
		
		/// RVD 6/13/2003 QA70-4650 v7.0601 OBJECT_PROPERTY_ACCESS
		//GraphPage gp;
		//gp.Create(NULL, CREATE_HIDDEN);
		//Tree trTheme;
		//trTheme = gp.GetFormat();
		//gp.Destroy();
		Tree trTheme;
		trTheme = Project.CreateNewTheme();
		/// end OBJECT_PROPERTY_ACCESS
		
		trTheme.Save(strFilename);
		///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
		if(strFilename.IsFile())
		{
			//load_themes_to_grid();
			//add_theme_to_grid(strFilename);
			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		
		string strName = GetFileName(strFilename, TRUE);
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		refreshGridList(strName);
		///End ADD_ANALYSIS_THEME_TO_TAB
		///End SELECT_CORRESPONDING_THEME
		return TRUE;
	}
	BOOL OnDuplicate(Control cntrl)
	{
		string		strSelThemeFile;
		if(!getSelThemeFile(strSelThemeFile))
			return TRUE; // nothing to do
		
		string strFilename;
		if(!getCopyOfThemeFileName(strFilename, strSelThemeFile))
			return false;
		///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
		if(FileCopy(strSelThemeFile, strFilename, FILE_ATTRIBUTE_NORMAL, true))
		{
			//add_theme_to_grid(strFilename);	//do not add theme to the end, refreshGridList will add it to proper place
			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		
		string strName = GetFileName(strFilename, TRUE);
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		refreshGridList(strName);  
		///End ADD_ANALYSIS_THEME_TO_TAB
		///End SELECT_CORRESPONDING_THEME
		return TRUE;
	}
	BOOL OnCombine(Control cntrl)
	{
		StringArray vstrThemeFilenames;

		if( !getSelThemeFiles(vstrThemeFilenames) )
			return TRUE; // nothing to do
		
		string strFilename;
		if(!getCombineThemeFileName(strFilename, vstrThemeFilenames[0]))
			return false;
		///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
		if( FileCopy(vstrThemeFilenames[0], strFilename, FILE_ATTRIBUTE_NORMAL, true) )
		{
			for(int ii=1; ii<vstrThemeFilenames.GetSize(); ii++)
			{
				if( !CombineThemes(strFilename, vstrThemeFilenames[ii]) )
					return FALSE;
			}
			
			//add_theme_to_grid(strFilename);

			LT_execute(STR_THEME_REMINDER_MSG_RENAME);
		}
		
		string strName = GetFileName(strFilename, TRUE);
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		refreshGridList(strName);
		///End ADD_ANALYSIS_THEME_TO_TAB
		///End SELECT_CORRESPONDING_THEME
		return TRUE;
	}
	BOOL OnApplyToComboChange(Control cntrl)
	{
		enable_buttons();
		return TRUE;
	}		
	BOOL OnApplyButton(Control cntrl)
	{		
		string		strApplyFile;

		if( !getSelThemeFile(strApplyFile) )
			return TRUE; // nothing to do
		
		BOOL bResult = theme_apply(getThemeApply(), strApplyFile);

		undo_enabled(true, 1); 

		return bResult;     
	}
	
	//---- CPY 4/30/03 ADD_UNDO_APPLY
	BOOL OnUndoApplyButton(Control cntrl)
	{
		if(undo_enabled())
		{
			Project.Undo();
			undo_enabled(true, -1);
		}
		
		return true;
	}
	//---- end
	
	///Jasmine 02/15/06 ADD_TYPE_TAB 
	BOOL	OnTabChange(Control cntrl)
	{
		int nSelTab = m_tabPage.GetCurSel();
		int nPageType = EXIST_NONE;
		
		Button btnShowGraphTypes = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);	//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
		
		switch(nSelTab)
		{
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		//case THEME_GRAPH_TAB:
			//nPageType = EXIST_PLOT;
			//break;
		//case THEME_WORKSHEET_TAB:
			//nPageType = EXIST_WKS;
			//break;
		case THEME_GRAPH_TAB:
			m_themGWList.Init(IDC_THEME_GRID, *this);
			nPageType = EXIST_PLOT;
			m_nThemeType = THTYPE_GRAPH;
			//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
			btnShowGraphTypes.Text = _L("Exclude increment lists");
			btnShowGraphTypes.Check = m_bExcludeIncremenTypes;
			//------ End EXCLUDE_LAST_USED_THEME
			break;			
		case THEME_WORKSHEET_TAB:
			m_themGWList.Init(IDC_THEME_GRID, *this);
			nPageType = EXIST_WKS;
			m_nThemeType = THTYPE_WORKSHEET;
			break;
		case THEME_ANALYSIS_TAB:
			m_themAnalysisList.Init(IDC_THEME_GRID, *this);
			m_nThemeType = THTYPE_ANALYSIS;
			//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
			btnShowGraphTypes.Text = _L("Exclude <last used> theme");
			btnShowGraphTypes.Check = m_bExcludeLastUsed;
			//------ End EXCLUDE_LAST_USED_THEME
			break;
		///End ADD_ANALYSIS_THEME_TO_TAB
		}
		
		btnShowGraphTypes.Visible = false;		//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
		
		onChangeDescription();///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
		///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
		//m_bCurrentPage = (nPageType == m_nPageType);
		m_bCurrentPage = isCurrentLayerAvailable(nPageType);
		///End NOT_APPLY_THEME_TO_REPORT_SHEET
		load_themes_to_grid(true, false);
		//setApplyToList();
		//enable_buttons();
		onTabShowRightBottom();///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
		return TRUE;
	}
	///End ADD_TYPE_TAB
	
	//////////////////////////
	// Delete Theme
	// move file into folder called "Deleted"
	//////////////////////////
		
	BOOL OnDelTheme(Control cntrl)
	{
		waitCursor junk;
		
		StringArray vstrThemeFilenames;

		if( !getSelThemeFiles(vstrThemeFilenames) )
			return TRUE; // nothing to do
		string strPath = okutil_theme_get_path(ORIGIN_PATH_USER, m_nThemeType);
		//------ Folger 07/11/08 CENTRLIZE_KNOWLEDGE_OF_THEME_DELETED_FOLDER
		//strPath += "Deleted";
		strPath += THEME_FILE_DELETED_FOLDER;
		//------
		
		if( CheckMakePath(strPath) )
		{
			bool bDeleted = false;
			
			//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
			vector<string>		vsClassOption;
			//------
			
			for(int ii=0; ii<vstrThemeFilenames.GetSize(); ii++)
			{
				string strTemp = GetFileName(vstrThemeFilenames[ii]);
				FileCopy(vstrThemeFilenames[ii], strPath + "\\" + strTemp);
				DeleteFile(vstrThemeFilenames[ii]);
				bDeleted = true;
				
				//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
				string strName, strTool, strScope, strCategory;
				theme_filename_to_options(vstrThemeFilenames[ii], strName, strTool, strScope ,strCategory);
				if ( vsClassOption.Find(strTool) < 0 )
					vsClassOption.Add(strTool);
				//------				
			}
			
			if( bDeleted )
			{	
				///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
				refreshGridList();
				///End ADD_ANALYSIS_THEME_TO_TAB
				
				LT_execute(STR_THEME_REMINDER_MSG_DEL);
				
				//------ Folger 04/25/08 CORRECTLY_UPDATE_THEME_MENU_AFTER_DELETE_THEME
				/*
				//------ Folger 04/17/08 NEED_TO_UPDATE_MENU_AFTER_DELTE_THEME
				refresh_origin_main_menu();
				//------
				*/
				for ( int jj=0; jj<vsClassOption.GetSize(); ++jj )
					UpdateThemesMenuItems(vsClassOption[jj]);
				//------
			}
		}
		
		return TRUE;
	}
	///////////////////////////////////////////////////////////////////////////////
	BOOL OnShowMenu(UINT nResIDCtrl, int nx, int ny)
	{
		if(IDC_THEME_GRID == nResIDCtrl)
		{
			int nRow = 0, nCol = 0;
			bool bIsInsideGrid = false;
			if(nx < 0 || ny < 0) // keyboard activated 
				bIsInsideGrid = m_themGWList.GetSelCell(nx, ny, nRow, nCol);
			else
				bIsInsideGrid = m_themGWList.FindCell(nx, ny, nRow, nCol);

			bool bHasSystemTheme = hasSystemTheme();
			bool bIsSystemTheme = m_themGWList.GetCheck(nRow, GRID_COL_IS_SYSTEM);
			bool bIsCanbeSystemTheme = false;
			StringArray vstrThemes;
			getSelThemeFiles(vstrThemes);
			
			bool bMulti = vstrThemes.GetSize() > 1;
			//---- CPY 8/19/03 INCREMENT_LIST_NO_SYSTEM_THEME_SUPPORT
			if(!bMulti && !isIncrementListRow(nRow)) // increment list theme is shown as italic
				bIsCanbeSystemTheme = true;
			//----
			///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
			//ThemeListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
			//myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
			//int nCmd;
			//if(myMenu.GetCommand(nCmd))
			//{
				//Control flxControl = GetItem(IDC_THEME_GRID);
				//switch(nCmd)
				//{
				//case THEME_ADD:
					//OnAdd(flxControl);
					//break;
				//case THEME_EDIT:
					//OnEditTheme(flxControl);
					//break;
				//case THEME_DELETE:
					//OnDelTheme(flxControl);
					//break;
				//case THEME_DUPLICATE:
					//OnDuplicate(flxControl);
					//break;
				//case THEME_COMBINE:
					//OnCombine(flxControl);
					//break;
				//case THEME_SET_SYSTEM:
					//setSystemTheme(nRow);
					//break;
				//case THEME_CLEAR_SYSTEM:
					//clearSystemTheme();
					//break;
				//case THEME_SHOW_TOOLTIPS:
					//m_bShowTooltips = m_bShowTooltips? false:true;
					//break;
				//}
			//}
			if(m_nThemeType == THTYPE_ANALYSIS)
			{
				ThemeAnalysisListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
				popupAnalysisMenu(myMenu, nx, ny);
			}
			else
			{
				///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
				//bool bEdit = isAllowEdit(nRow);///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
				//ThemeGWListControlMenu	myMenu(bEdit, bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
				ThemeGWListControlMenu	myMenu(bIsSystemTheme, bHasSystemTheme, bIsInsideGrid, bMulti, bIsCanbeSystemTheme, m_bShowTooltips);
				///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
				popupGWListMenu(myMenu, nRow, nx, ny); //graph and worksheet
			}
			///End ADD_ANALYSIS_THEME_TO_TAB
			return FALSE;
		}
		return TRUE;
	}	
	//------------ vcFlex Grid Event Handlers ------------
	/////////////////////////////////////////
	//
	void OnBeforeMouseDown(Control flxControl, short nButton, short nShift, float X, float Y, BOOL* pCancel) // listCols arg not used for now, maybe needed later
	{
		int nRow, nCol, nx, ny;
		bool bIsInsideGrid = m_themGWList.GetMousePixel(X, Y, nRow, nCol, nx, ny);
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
		{
			if(m_themAnalysisList.CheckSelRow(nRow, false))
				*pCancel= TRUE;
			return;
		}
		///End ADD_ANALYSIS_THEME_TO_TAB
		if(m_themGWList.CheckSelRow(nRow, false))
		{
			*pCancel= TRUE;
			if(nRow < 0)
				enable_buttons();
		}
	}
	void OnDblClick(Control flxControl)
	{		
		int nRow = 0, nCol = 0;
		int nx = -1, ny = -1;
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
			return;
		///End ADD_ANALYSIS_THEME_TO_TAB
		m_themGWList.GetSelCell(nx, ny, nRow, nCol);
		///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		//if(nCol != GRID_COL_NAME && isAllowEdit(nRow))	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME		
		if(nCol != GRID_COL_NAME )
		///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
			OnEditTheme(flxControl);
	}

	void OnBeforeEdit(Control flxControl, long nRow, long nCol, BOOL* pCancel)
	{	
		///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
		if(!isAllowEdit(nRow))
		{
			*pCancel = TRUE;
			return;
		}
		///End NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS) 
		{
			if(nCol != ANALYSIS_GRID_COL_NAME && nCol != ANALYSIS_GRID_COL_IS_SYSTEM && nCol != ANALYSIS_GRID_COL_MENU)
			{
				*pCancel = TRUE;
				return;
			}
			if( ANALYSIS_GRID_COL_NAME == nCol)
				m_strOldStr = m_themAnalysisList.GetCell(nRow, nCol);
			else
				m_strOldStr = "";
		}
		else
		{
			if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM)
			//---
			{
				*pCancel = TRUE;
				return;
			}
			
			if( GRID_COL_NAME == nCol)
				m_strOldStr = m_themGWList.GetCell(nRow, nCol);
			else
				m_strOldStr = "";
		}
			////--- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
		////if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM && nCol != GRID_COL_EDIT)
		//if(nCol != GRID_COL_NAME && nCol != GRID_COL_IS_SYSTEM)
		////---
		//{
			//*pCancel = TRUE;
			//return;
		//}
		//
		//if( GRID_COL_NAME == nCol)
			//m_strOldStr = m_themeList.GetCell(nRow, nCol);
		//else
			//m_strOldStr = "";
		///End ADD_ANALYSIS_THEME_TO_TAB
	}
	
	void OnAfterEdit(Control flxControl, int nRow, int nCol)
	{
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		//if(GRID_COL_NAME == nCol)
		//{
			//string strNew = m_themGWList.GetCell(nRow, nCol);
			//if(strNew.CompareNoCase(m_strOldStr) != 0)
			//{
				//// need to rename file
				/////DSC 2/15/05 GET_ORIGIN_PATH
				//// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
				//// if(!theme_rename(strNew, m_strOldStr, bIsEXEPath))
				//int nPathThpe = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
				//// if(!theme_rename(strNew, m_strOldStr, nPathThpe))
				//if(!theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType))
				/////end 2/15/05 GET_ORIGIN_PATH
					//m_themGWList.SetCell(nRow, nCol, m_strOldStr);
				//else
					//checkSystemTheme(nRow);
			//}
			//return;
		//}
		///*
		//else if(GRID_COL_IS_SYSTEM == nCol)
		//{
			//bool bCheck = m_themGWList.GetCheck(nRow, nCol);
			//string strTheme = m_themGWList.GetCell(nRow, GRID_COL_NAME);
			//bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			//theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
			//// next we need to clean those other checked since only one system theme is allowed
			//checkSystemTheme();
		//}
		//*/
		if(m_nThemeType == THTYPE_ANALYSIS) 
		{			
			afterEditUsed(m_themAnalysisList, nCol, nRow, ANALYSIS_GRID_COL_NAME, ANALYSIS_GRID_COL_PATH);
		}
		else
		{
			afterEditUsed(m_themGWList, nCol, nRow, GRID_COL_NAME, GRID_COL_LOCATION);
		}
		///End  ADD_ANALYSIS_THEME_TO_TAB
	}
	void OnSelChange(Control flxControl)
	{
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
			return;
		///End ADD_ANALYSIS_THEME_TO_TAB
		enable_buttons();	
	}	
	BOOL OnEditTheme(Control cntrl)
	{
		string		strThemeFile;
		if(!getSelThemeFile(strThemeFile))
			return TRUE; // nothing to do
		
		int nSelRow = m_themGWList.GetSelectedRow();
		P_THEME_EDITOR fnThemeEditor = Project.FindFunction("ThemeEditor");
		if(fnThemeEditor)
		{
			///Kyle 02/02/2010 QA80-14829 SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
			/*
			if(fnThemeEditor(strThemeFile, GetSafeHwnd()))
			{
				// need to update size col
				Tree themeTree(strThemeFile);
				if(themeTree)
				{
					//if(m_nThemeType == THTYPE_ANALYSIS)
						//m_themAnalysisList.SetCell(nSelRow, ANALYSIS_GRID_COL_SIZE, tree_count_items(themeTree));
					//else
						m_themGWList.SetCell(nSelRow, GRID_COL_SIZE, tree_count_items(themeTree));
				}
			}
			*/
			string strEditingFile;
			fnThemeEditor(strThemeFile, GetSafeHwnd(), &strEditingFile);

			string strName = GetFileName(strEditingFile, TRUE);
			refreshGridList(strName);
			///End SAVE_AS_FOR_BUILT_IN_OR_GROUP_SHARED_THEME
		}
		return TRUE;
	}
	//---------- CPY 4/25/03 ADD_FILE_DATE and ADD_TOOLTIPS
	void OnMouseMove(Control flxControl, short nButton, short nShift, float X, float Y)
	{
		string strTooltips;
		if(!m_bShowTooltips)
			return;
		
		int nRow, nCol;
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
		{			
			if(!m_themAnalysisList.GetMouseCell(nRow, nCol))
				return;
			
			if(m_themAnalysisList.IsColHeadingRow(nRow))
				strTooltips = get_analysis_col_heading_tooltips(nCol);
			else if(ANALYSIS_GRID_COL_NAME == nCol)
				strTooltips = get_theme_tooltips(nRow);	
		}
		else
		///End ADD_ANALYSIS_THEME_TO_TAB
		{
		
			if(!m_themGWList.GetMouseCell(nRow, nCol))
				return;
			
			if(m_themGWList.IsColHeadingRow(nRow))
				strTooltips = get_gw_col_heading_tooltips(nCol);
			else if(GRID_COL_NAME == nCol)
				strTooltips = get_theme_tooltips(nRow);	
		}
		// this is not working, will need a ADO version, I suspect
		//flx.ToolTipText = strTooltips;
		show_tooltip_text(strTooltips);
		
	}
	//---------- end ADD_TOOLTIPS

private:
	///Jasmine 09/20/07 NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	bool isAllowEdit(int nRow)
	{
		int nPathType = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
		return (ORIGIN_PATH_GROUP == nPathType || ORIGIN_PATH_SYSTEM == nPathType)? false : true
	}
	///End NOT_ALLOW_EDIT_BUILTIN_OR_GROUP_THEME
	///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET
	bool isCurrentLayerAvailable(int nTabType)
	{
		if(nTabType == m_nPageType)
		{
			if(EXIST_WKS == m_nPageType)
			{
				Worksheet wks = Project.ActiveLayer();
				return !(wks.GetSystemParam(0) & WP_SHEET_HIERARCHY);
			}
			return true;
		}
		return false;
	}
	///End NOT_APPLY_THEME_TO_REPORT_SHEET
	///Joseph 10/25/06 HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB
	void onTabShowRightBottom()
	{
		bool bShowRight, bShowBottom;
		switch(m_nThemeType)
		{
		case THTYPE_GRAPH:
			bShowRight = true;
			bShowBottom = true;
			break;
		case THTYPE_WORKSHEET:
			bShowRight = true;
			bShowBottom = false;
			break;
		case THTYPE_ANALYSIS:
			bShowRight = false;
			//------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
			//bShowBottom = false;
			bShowBottom = true;
			//------ End EXCLUDE_LAST_USED_THEME
			break;
		default:
			break;
		}
		
		uint uRightControl[] = {IDC_STATIC_SET_SYSTEM_THEME, IDC_STATIC_CURRENT_SYSTEM_THEME, IDC_THEME_CURRENT_SYSTEM, IDC_THEME_APPLY_TO, IDC_THEME_APPLY_GROUP, IDC_THEME_APPLY, IDC_THEME_UNDO, 0};
		ShowControls(uRightControl, bShowRight);
		
		uint uBottomControl[] = {IDC_THEME_SHOW_GRAPH_ONLY , 0}
		ShowControls(uBottomControl, bShowBottom);
		if(bShowRight)
		{
			setApplyToList();
			enable_buttons();
		}			
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
	}
	///End HIDE_RIGHTCONTROL_ON_ANALYSIS_TAB
	bool hasSystemTheme()
	{
		string str = m_cntrlSystemTheme.Text;
		return str.IsEmpty()? false:true;
	}
	void setSystemTheme(int nRow)
	{
		if(nRow < 0)
			return;
		int nCol = GRID_COL_IS_SYSTEM;
		bool bCheck = m_themGWList.GetCheck(nRow, nCol);
		if(bCheck)
			return;
		bCheck = true;
		string strTheme = m_themGWList.GetCell(nRow, GRID_COL_NAME);
		
		///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
		// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
		// theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
		int nPathType = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
		theme_system_getset(strTheme, true, bCheck, nPathType, m_nThemeType);
		///end USE_ENUM_ORIGIN_PATH_TYPE
		
		// next we need to clean those other checked since only one system theme is allowed
		checkSystemTheme();
	}
	void clearSystemTheme() // can ignore this for now
	{
		bool bCheck;//, bIsEXEPath
		int nRow1, nRow2;
		m_themGWList.GetRowRange(nRow1, nRow2);
		string strTheme;
		for(int nRow = nRow1; nRow <= nRow2; nRow++)
		{
			strTheme = m_themGWList.GetCell(nRow, GRID_COL_NAME);
			///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
			// bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			// bCheck = theme_system_getset(strTheme, false, false, bIsEXEPath)? true : false;	///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
			int nPathType = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
			bCheck = theme_system_getset(strTheme, false, false, nPathType, m_nThemeType)? true : false;
			///end USE_ENUM_ORIGIN_PATH_TYPE
			
			if(bCheck)
			{
				bCheck = false;
				///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
				// theme_system_getset(strTheme, true, bCheck, bIsEXEPath);
				theme_system_getset(strTheme, true, bCheck, nPathType, m_nThemeType);
				///end USE_ENUM_ORIGIN_PATH_TYPE
				m_themGWList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
				//---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
				//m_themGWList.SetBold(nRow, GRID_COL_NAME, bCheck);
				m_themGWList.SetBold(nRow, -1, bCheck);
				//---
			}
		}
		m_cntrlSystemTheme.Text = "";
	}
	bool getNextThemeFileName(string& strFilename)
	{	
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		//string strThemePath = okutil_theme_get_path();
		string strThemePath = okutil_theme_get_path(ORIGIN_PATH_USER, m_nThemeType);
		///End ADD_ANALYSIS_THEME_TO_TAB
		strFilename = strThemePath + strFilename;
		return get_next_file_name(strFilename);
	}
	bool getCopyOfThemeFileName(string& strFilename, const string& strThemeFilename)
	{
		//---- CPY 9/20/03 THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
		//string strOldThemeFilename = GetFileName(strThemeFilename);
		//strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		//string strOldThemeFilename = GetFileName(strThemeFilename, TRUE); // remove ext, and add later
		//strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
		//strFilename += "." + THEME_FILE_EXT;
		string strOldThemeFilename = GetFileName(strThemeFilename, TRUE); // remove ext, and add later
		if(m_nThemeType == THTYPE_ANALYSIS)
		{
			/// EJP 2009-01-26 QA80-13021 SUPPORT_DASH_IN_THEME_NAME
			// OIS file name syntax is "<#>-<XFuncName>-<ThemeName>.ois"
			// ReverseFind can not support dash in theme name. Safer to find 2nd dash from beginning of string.
			///int nScopeIndex = strOldThemeFilename.ReverseFind('-');
			int nScopeIndex = strOldThemeFilename.Find('-');
			if( nScopeIndex >= 0 ) // If found first dash 
				nScopeIndex = strOldThemeFilename.Find('-', nScopeIndex + 1); // Find 2nd dash
			/// end SUPPORT_DASH_IN_THEME_NAME
			strOldThemeFilename.Insert(nScopeIndex + 1, "Copy of ");
			strFilename = strOldThemeFilename + "." + ANALYSIS_THEME_FILE_EXT;
		}
		else
		{
			strFilename.Format(_L("Copy of %s"), strOldThemeFilename);
			strFilename += "." + THEME_FILE_EXT;
		}
		///End ADD_ANALYSIS_THEME_TO_TAB
		//---- end THEME_DUPLICATE_LEAD_TO_SIZE_OF_NEGATIVE_1
		return getNextThemeFileName(strFilename);
	}
	bool getCombineThemeFileName(string& strFilename, const string& strThemeFilename)
	{
		strFilename = _L("Combined theme");
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
			add_file_extension(strFilename, ANALYSIS_THEME_FILE_EXT);
		else
		///End ADD_ANALYSIS_THEME_TO_TAB
			add_file_extension(strFilename, THEME_FILE_EXT);
		return getNextThemeFileName(strFilename);
	}
	bool getSelThemeFile(string& strThemeFilename)
	{
		int nSelRow = m_themGWList.GetSelectedRow();
		if(nSelRow < 0)
			return false;
		
		strThemeFilename = get_theme_file_name(nSelRow);		
		return true;
	}
	bool getSelThemeFiles(StringArray& vstrThemeFilenames)
	{
		vector<uint> vnRows;
		
		if( !m_themGWList.GetSelRows(vnRows) )
			return false;
		
		if( !vstrThemeFilenames.SetSize(vnRows.GetSize()) )
			return false;
		
		for(int ii=0; ii<vnRows.GetSize(); ii++)
			vstrThemeFilenames[ii] = get_theme_file_name(vnRows[ii]);
			
		return true;
	}
	string get_theme_file_name(int nRow)
	{
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
		if(m_nThemeType == THTYPE_ANALYSIS)
		{
			string strTheme = m_themAnalysisList.GetCell(nRow, ANALYSIS_GRID_COL_NAME);
			string strScopeName = m_themAnalysisList.GetCell(nRow, ANALYSIS_GRID_COL_SCOPE);
			string strTool = m_themAnalysisList.GetCell(nRow, ANALYSIS_GRID_COL_FUNCTION);
			convColOrRowtoIndex(strTool);
			string strCategory = m_themAnalysisList.GetCell(nRow, ANALYSIS_GRID_COL_CATEGORY);
			int nScope = theme_scopename_to_scopeindex(strScopeName);
			int nPathType = m_themGWList.GetCellData(nRow, ANALYSIS_GRID_COL_PATH);
			string strFileName = okutil_theme_construct_filename(strTheme, m_nThemeType , nPathType, nScope, strTool, strCategory);	
			return strFileName;
		}
		else
		///End ADD_ANALYSIS_THEME_TO_TAB
		{			
			string strTheme = m_themGWList.GetCell(nRow, GRID_COL_NAME);
			///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
			// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			// return theme_get_theme_file_name(strTheme, bIsEXEPath);
			int nPathType = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
			///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME
			//return theme_get_theme_file_name(strTheme, nPathType);
			//return theme_get_theme_file_name(strTheme, THTYPE_GRAPH, nPathType);
			return okutil_theme_get_theme_file_name(strTheme, m_nThemeType, nPathType);///DSC 2/23/05
			///end UPDATE_THEME_GET_FILENAME
			///end USE_ENUM_ORIGIN_PATH_TYPE
		}
	}
	string get_theme_tooltips(int nRow)
	{
		string strThemeFile = get_theme_file_name(nRow);
		string strComments;
		Tree trTemp(strThemeFile);
		if(trTemp)
			trTemp.GetAttribute(STR_THEME_COMMENT_ATTRIB, strComments);
		
		return strComments;
	}
	// there seems to be no tooltip support for this version of vsFlex, so
	// just use dialog title for now
	void show_tooltip_text(string& str)
	{
		m_themGWList.SetToolTipsText(str);
	}
	int		getThemeApply()
	{
		int nApplyTo = m_cmbApplyTo.GetCurSel();
		
		if( nApplyTo < 0 )
			nApplyTo = 0;
		
		int nOffset = THEMEAPPLY_FOLDER;
		///Jasmine 09/07/07 NOT_APPLY_THEME_TO_REPORT_SHEET 
		//if( m_bCurrentPage )
		//{
		switch( m_nThemeType )
		{
		case THTYPE_GRAPH:
			if(m_bCurrentPage)
				nOffset = THEMEAPPLY_PAGE;
			break;
			
		case THTYPE_WORKSHEET:
			nOffset = m_bCurrentPage? THEMEAPPLY_LAYER : THEMEAPPLY_PAGE;
			break;
		}
		//}
		///End NOT_APPLY_THEME_TO_REPORT_SHEET
		return nOffset + nApplyTo;
	}
	void enable_buttons()
	{
		int nSelRow = m_themGWList.GetSelectedRow();
		bool bEnable = nSelRow<0? false:true;
		
		///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
		//if(m_tabPage)
		//{
			//Button btn = GetItem(IDC_THEME_SHOW_GRAPH_ONLY);
			//btn.Enable = (m_tabPage.GetCurSel() == THEME_GRAPH_TAB);
		//}		
		///End CLEAN_THEME_ORGANIZER
		
		int nBtnIds[] = {IDC_THEME_APPLY,0};//, IDC_THEME_APPLY_TO, IDC_THEME_UNDO, 0};
		for(int ii=0; nBtnIds[ii] > 0; ii++)
		{
			Button btn = GetItem(nBtnIds[ii]);
			btn.Enable = bEnable;
		}
	}
	///Jasmine 02/15/06 ADD_TYPE_TAB 
	void show_buttons(bool bShow = true)
	{
		int nBtnIds[] = {IDC_THEME_APPLY,0};
		int ii = 0;
		while(nBtnIds[ii] > 0)
		{
			Button btn = GetItem(nBtnIds[ii++]);
			btn.Enable = bShow;
		}
	}
	void setApplyToList()
	{
		m_cmbApplyTo.ResetContent();
		
		switch(m_nThemeType)
		{
		case THTYPE_GRAPH:
			if( m_bCurrentPage )
				m_cmbApplyTo.AddString(_L("Current Graph")); 
			m_cmbApplyTo.AddString(_L("Graphs in Folder"));
			m_cmbApplyTo.AddString(_L("Graphs in Project"));
			if(EXIST_WKS == m_nPageType)	///Jasmine 03/24/07 APPLY_THENE_TO_GRAPH_IN_WKS
				m_cmbApplyTo.AddString(_L("Graphs in Current Sheet"));
			break;
			
		case THTYPE_WORKSHEET:
			if( m_bCurrentPage )
				m_cmbApplyTo.AddString(_L("Current Sheet")); 
			m_cmbApplyTo.AddString(_L("Sheets in Book"));
			m_cmbApplyTo.AddString(_L("Sheets in Folder"));
			m_cmbApplyTo.AddString(_L("Sheets in Project"));
			break;
			
		default:
			return;
		}
		
		m_cmbApplyTo.SetCurSel(0);
	}
	///End ADD_TYPE_TAB
	
	// if bUpdateButton, then
	// nInc = 0 --> init
	// inc > 0 or < 0, inc/decrement count
	bool undo_enabled(bool bUpdateButton = false, int nInc = 0)
	{
		Button btnUndo = GetItem(IDC_THEME_UNDO);
		if(bUpdateButton)
		{
			if(0==nInc)
				m_nUndoStackCount = 0;
			else
				m_nUndoStackCount += nInc;
			
			btnUndo.Enable = m_nUndoStackCount > 0? true:false;
		}
		
		return btnUndo.Enable;
	}
	void checkSystemTheme(int nRowToCheck = -1) // 
	{	
		string strThemeName;
		int nRow1 = nRowToCheck, nRow2 = nRowToCheck;
		if(nRowToCheck < 0)
			m_themGWList.GetRowRange(nRow1, nRow2);
		string strSystemTheme;
		
		/// DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME
		//-- read system theme from ini once, not each time in the loop
		string strSysThemeINI, strSysThemePathKeyWordINI;
		//strSysThemeINI = theme_get_system_theme(&strSysThemePathKeyWordINI);
		strSysThemeINI = okutil_theme_get_system_theme(m_nThemeType);
		///end CLEANUP_GET_SYSTEM_THEME
		
		for(int nRow = nRow1; nRow <= nRow2; nRow++)
		{
			strThemeName = m_themGWList.GetCell(nRow, GRID_COL_NAME);
			
			///DSC 2/17/05 USE_ENUM_ORIGIN_PATH_TYPE
			// ///Danice MARK_SYSTEM_THEME_WITH_NAME_AND_PATH
			// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
			// bool bCheck = theme_system_getset(strThemeName, false, false, bIsEXEPath)? true : false;
			// ///end
			int nPathType = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION);
			
			// Category NULL for graph and wks themes
			// strThemeName = okutil_str_construct_path_category_name(nPathType, NULL, strThemeName);
			strThemeName = okutil_composite_name_from_components(nPathType, NULL, strThemeName);
			
			/// DSC 2/19/05 v8.0195 QA70-7416 CLEANUP_GET_SYSTEM_THEME  read system theme from ini once, not each time in the loop
			// bool bCheck = theme_system_getset(strThemeName, false, false, nPathType)? true : false;
			//-- check if theme agrees with system theme from ini file
			bool bCheck = false;
			// if( 0==strThemeName.CompareNoCase(strSysThemeINI) && 0==strSysThemePathKeyWordINI.CompareNoCase(get_origin_path_keyword(nPathType)) )
			if( 0==strThemeName.CompareNoCase(strSysThemeINI))
				bCheck = true;
			///end CLEANUP_GET_SYSTEM_THEME
			
			///end USE_ENUM_ORIGIN_PATH_TYPE
			if(bCheck)
				strSystemTheme = strThemeName;
				
			m_themGWList.SetCheck(nRow, GRID_COL_IS_SYSTEM, bCheck);
			//---CPY 8/18/03 BOLD_SYSTEM_THEME_WHOLE_ROW
			//m_themGWList.SetBold(nRow, GRID_COL_NAME, bCheck);
			m_themGWList.SetBold(nRow, -1, bCheck);
			//---
		}
		m_cntrlSystemTheme.Text = strSystemTheme;
	}
	int addThemes(TreeNode& trNode)
	{
		int nRow = -1;
		string str, strLocation, strThemeName;
		foreach(TreeNode tn in trNode.Children)
		{			
			int nType;
			tn.GetAttribute(THEME_TYPE_ATTRIBUTE, nType);
			
			///DSC 2/16/05 GET_ORIGIN_PATH 
			// bool bIsEXEPath = nType == THTYPE_SYSTEM? true:false;
			// if(bIsEXEPath)
			// 	strLocation = STR_THEME_TYPE_SYSTEM;
			// else
			// 	strLocation = STR_THEME_TYPE_USER;
			strLocation = okutil_get_origin_path_keyword(nType);
			///end GET_ORIGIN_PATH
			
			
			strThemeName = tn.strVal;
			//--- CPY 4/1/03 CHECK_BOX_TO_SHOW_ONLY_GRAPH_THEME
			///DSC 2/16/05 GET_ORIGIN_PATH
			// string strThemeFilename = theme_get_theme_file_name(strThemeName, bIsEXEPath);
			///Iris 2/22/05 QA70-7416 UPDATE_THEME_GET_FILENAME
			//string strThemeFilename = theme_get_theme_file_name(strThemeName, nType);
			// string strThemeFilename = theme_get_theme_file_name(strThemeName, THTYPE_GRAPH, nType);
			string strThemeFilename = okutil_theme_get_theme_file_name(strThemeName, m_nThemeType, nType);///DSC 2/23/05
			///end UPDATE_THEME_GET_FILENAME
			///end GET_ORIGIN_PATH
			bool bIsIncrementList = theme_is_increment_theme(strThemeFilename);
			if(m_bExcludeIncremenTypes && bIsIncrementList)
				continue;
			//--- 
			string strDate = GetFileModificationDate(strThemeFilename, LDF_SHORT_AND_HHMM_SEPARCOLON); //CPY 4/25/03 ADD_FILE_DATE
			
			//----- CPY 3/27/03 EDIT_THEME_CHANGE_TO_BUTTON
			//str = "\t" + strLocation + "\t" + "click->" + "\t" + strThemeName;
			int nSize = theme_count_properties(strThemeFilename);	
			///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB  	
			//str = "\t" + strThemeName + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
			////-----
				//nRow = m_themGWList.AddTheme(str, nType, bIsIncrementList);
			if(m_nThemeType == THTYPE_ANALYSIS)
			{
				string strName, strTool, strScope, strCategory;
				theme_filename_to_options(strThemeName, strName, strTool, strScope ,strCategory);
				//------ Folger 11/05/07 CORRECT_THEME_TYPE_COMPARE
				////------ Folger 08/31/07 EXCLUDE_LAST_USED_THEME
				//if (m_bExcludeLastUsed && strName.CompareNoCase("Last used") == 0)
					//continue;
				////------ End EXCLUDE_LAST_USED_THEME
				if (m_bExcludeLastUsed && is_theme_last_used(strName))
					continue;
				//------ End CORRECT_THEME_TYPE_COMPARE
				///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
				//str = "\t" + "" + "\t" + strName + "\t" + strTool + "\t" + strCategory + "\t" + strScope + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
				vector<string> vsColValues(ANALYSIS_GRID_COL_TOTAL);
				vsColValues[ ANALYSIS_GRID_COL_IS_SYSTEM ] = "";
				vsColValues[ ANALYSIS_GRID_COL_MENU ] = "";
				vsColValues[ ANALYSIS_GRID_COL_NAME ] = strName;
				vsColValues[ ANALYSIS_GRID_COL_FUNCTION ] = strTool;
				vsColValues[ ANALYSIS_GRID_COL_CATEGORY ] = strCategory;
				vsColValues[ ANALYSIS_GRID_COL_SCOPE ]= strScope;
				vsColValues[ ANALYSIS_GRID_COL_SIZE ] = (string)nSize;
				vsColValues[ ANALYSIS_GRID_COL_PATH ] = strLocation;
				vsColValues[ ANALYSIS_GRID_COL_DATE ] = strDate;
				str.SetTokens(vsColValues, '\t');
				///End USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
				nRow = m_themAnalysisList.AddTheme(str, nType, bIsIncrementList);
			}
			else			
			{
				///Jasmine 12/30/09 QA81-14829 USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
				//str = "\t" + strThemeName + "\t" + nSize + "\t" + strDate + "\t" + strLocation;
				vector<string> vsColValues(GRID_COL_TOTAL);
				vsColValues[ GRID_COL_IS_SYSTEM ]= "";
				vsColValues[ GRID_COL_NAME ] = strThemeName;
				vsColValues[ GRID_COL_SIZE ]= (string)nSize;
				vsColValues[ GRID_COL_LOCATION ] = strLocation;
				vsColValues[ GRID_COL_DATE ]= strDate;
				str.SetTokens(vsColValues, '\t');
				///End USER_IS_MORE_CONCERNED_ABOUT_THEME_PATH
				nRow = m_themGWList.AddTheme(str, nType, bIsIncrementList);
			}
			///End ADD_ANALYSIS_THEME_TO_TAB
		}
		return nRow;
	}
	
	bool isIncrementListRow(int nRow)
	{
		return m_themGWList.IsItalic(nRow, GRID_COL_NAME);
	}
	
	void load_themes_to_grid(bool bRemoveOld = true, bool bSelLast = true)
	{
		if(bRemoveOld)
		{	
			///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB 
			//m_themeList.Reset();
			if(m_nThemeType == THTYPE_ANALYSIS)
				m_themAnalysisList.Reset();
			else
				m_themGWList.Reset();
			///End ADD_ANALYSIS_THEME_TO_TAB
		}
		
		Tree trTemp;
		trTemp.AddNode("Themes");
		
		// theme_find_all_theme_files(trTemp.FirstNode);
		theme_find_all_theme_files(trTemp.FirstNode, ORIGIN_PATH_UNDEF, m_nThemeType);///DSC 2/23/05
	
		addThemes(trTemp.FirstNode);
		checkSystemTheme();
		resizeThemeCols();	
		///Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB 
		if(m_nThemeType == THTYPE_ANALYSIS)
			m_themAnalysisList.SelRow(-1, bSelLast);
		else
			m_themGWList.SelRow(-1, bSelLast);
		///End ADD_ANALYSIS_THEME_TO_TAB
	}
	void add_theme_to_grid(const string& strThemeFilename, bool bUser = true, bool bSelIt = true)
	{
		Tree trTemp;
		trTemp.AddNode("Themes");
		//theme_add_one_theme_file(trTemp.FirstNode, strThemeFilename, bUser);	///Jasmine 12/30/09 see DSC 2/16/05 GET_ORIGIN_PATH
		///Kyle 07/05/2010 QA80-13021-P2 theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
		//theme_add_one_theme_file(trTemp.FirstNode, strThemeFilename, bUser? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM);
		theme_add_one_theme_file(trTemp.FirstNode, GetFileName(strThemeFilename, true), bUser? ORIGIN_PATH_USER : ORIGIN_PATH_SYSTEM);
		///End theme_add_one_theme_file_ACCEPT_FILE_NAME_WITHOUT_PATH
		int nRow = addThemes(trTemp.FirstNode);
		checkSystemTheme();
		resizeThemeCols();	
		if(bSelIt)
			m_themGWList.SelRow(nRow, true);
	}
	void resizeThemeCols()
	{
		m_themGWList.ResizeCols(2);// was 3, Easwar said he has theme name longer	
	}
	void load_options()
	{
		m_bShowTooltips = true;
		vector<byte> vbCheckSettings;
		if(load_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName) && vbCheckSettings.GetSize() > 0)
			m_bShowTooltips = vbCheckSettings[0];
	}
	void save_options()
	{
		vector<byte> vbCheckSettings;
		vbCheckSettings.Add(m_bShowTooltips);
		save_default_checkboxes(m_strOptionsSecName, vbCheckSettings, m_strOptionsValName);
	}
	/// Joe 8/08/06  ADD_ANALYSIS_THEME_TO_TAB
	void afterEditUsed(ThemeListControlBase &ThemeList, int nCol, int nRow, int nColName, int nColLocation)
	{
		if(nColName == nCol)
		{
			string strNew = ThemeList.GetCell(nRow, nCol);
			if(strNew.CompareNoCase(m_strOldStr) != 0)
			{
				// need to rename file
				///DSC 2/15/05 GET_ORIGIN_PATH
				// bool bIsEXEPath = m_themGWList.GetCellData(nRow, GRID_COL_LOCATION) == THTYPE_SYSTEM? true:false;
				// if(!theme_rename(strNew, m_strOldStr, bIsEXEPath))
				int nPathThpe = ThemeList.GetCellData(nRow, nColLocation);
				// if(!theme_rename(strNew, m_strOldStr, nPathThpe))
				///Jasmine 09/29/07 QA70-7416 FIX_RENAME_ANALYSIS_THEME_BUG
				//if(!theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType))
				bool bRet;
				if(m_nThemeType == THTYPE_ANALYSIS) 
				{
					string strFullNewName, strFullOldName;
					getSelThemeFile(strFullNewName);
					strFullOldName = strFullNewName = GetFileName(strFullNewName, TRUE);
					strFullOldName.Replace(strNew, m_strOldStr);
					bRet = theme_rename(strFullNewName, strFullOldName, nPathThpe, m_nThemeType);
				}
				else
					bRet = theme_rename(strNew, m_strOldStr, nPathThpe, m_nThemeType);
				///End FIX_RENAME_ANALYSIS_THEME_BUG
				if(!bRet)
				///end 2/15/05 GET_ORIGIN_PATH
					ThemeList.SetCell(nRow, nCol, m_strOldStr);
				else
					checkSystemTheme(nRow);
			}
		}
	}

	void popupAnalysisMenu(ThemeListControlMenuBase& myMenu, int nx, int ny)
	{
		myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			Control flxControl = GetItem(IDC_THEME_GRID);
			switch(nCmd)
			{
			//case ANALYSIS_THEME_EDIT:
				//OnEditTheme(flxControl);
				//break;
			case ANALYSIS_THEME_DELETE:
				OnDelTheme(flxControl);
				break;
			case ANALYSIS_THEME_DUPLICATE:
				OnDuplicate(flxControl);
				break;
			//case ANALYSIS_THEME_COMBINE:
				//OnCombine(flxControl);
				//break;
			case ANALYSIS_THEME_SHOW_TOOLTIPS:
				m_bShowTooltips = m_bShowTooltips? false:true;
				break;
			}
		}
	}
	
	void popupGWListMenu(ThemeListControlMenuBase& myMenu, int nRow, int nx, int ny)
	{
		myMenu.TrackPopupMenu(0,  nx, ny, m_wndDlg.GetSafeHwnd());
		int nCmd;
		if(myMenu.GetCommand(nCmd))
		{
			Control flxControl = GetItem(IDC_THEME_GRID);
			switch(nCmd)
			{
			case THEME_ADD:
				OnAdd(flxControl);
				break;
			case THEME_EDIT:
				OnEditTheme(flxControl);
				break;
			case THEME_DELETE:
				OnDelTheme(flxControl);
				break;
			case THEME_DUPLICATE:
				OnDuplicate(flxControl);
				break;
			case THEME_COMBINE:
				OnCombine(flxControl);
				break;
			case THEME_SET_SYSTEM:
				setSystemTheme(nRow);
				break;
			case THEME_CLEAR_SYSTEM:
				clearSystemTheme();
				break;
			case THEME_SHOW_TOOLTIPS:
				m_bShowTooltips = m_bShowTooltips? false:true;
				break;
			}
		}
	}
	void convColOrRowtoIndex(string& strTool)
	{
		if(strTool.Find("DescStats") == 0)
		{
			///---Sim 10-10-2007 FIX_THEME_NAME_ASSIGNED_ERROR
			/*
			if(strTool.Find("(Row)"))
				strTool.Replace("(Row)","");
			if(strTool.Find("(Col)"))
				strTool.Replace("(Col)","_1");
			*/
			if(strTool.Find("(Row)"))
				strTool.Replace("(Row)","_1");
			if(strTool.Find("(Col)"))
				strTool.Replace("(Col)","");
			///---END FIX_THEME_NAME_ASSIGNED_ERROR
		}
	}
	///Jasmine QA81-14829 SELECT_CORRESPONDING_THEME
	void refreshGridList(LPCSTR lpcszThemeName = NULL)
	{
		int nNameCol;
		ThemeListControlBase* pList = NULL; 
		if(m_nThemeType == THTYPE_ANALYSIS)
		{
			nNameCol = ANALYSIS_GRID_COL_NAME;
			pList = &m_themAnalysisList;
		}
		else
		{
			nNameCol = GRID_COL_NAME;
			pList = &m_themGWList;
		}
			
		if(pList == NULL)
			return;
		//pList->ClearAll();	//load_themes_to_grid will reset the grid
		load_themes_to_grid(true, false);
		
		if(lpcszThemeName)
		{
			int nRow = pList->FindRow(lpcszThemeName, nNameCol);
			pList->SelRow(nRow);
		}
	}
	///End SELECT_CORRESPONDING_THEME
	///End ADD_ANALYSIS_THEME_TO_TAB
	///Joseph 01/23/06 CLEAN_THEME_ORGANIZER
	void onChangeDescription()
	{
		Control ctrl = GetItem(IDC_STATIC_SYSTEM_THEME_DESCIPTION);
		if(!ctrl)
			return;
		
		switch(m_nThemeType)
		{
		case THTYPE_GRAPH:
			ctrl.Text = _L("A system theme can be applied automatically when making new graphs");
			break;
		case THTYPE_WORKSHEET:
			ctrl.Text = _L("A system theme can be applied automatically when making new worksheet");
			break;
		case THTYPE_ANALYSIS:
			ctrl.Text = _L("A dialog theme can be applied automatically when reopen its corresponding dialog");
			break;
		}
	}
    ///End CLEAN_THEME_ORGANIZER
private:
	string	m_strOptionsSecName;
	string	m_strOptionsValName;
	bool	m_bShowTooltips;
};
 
#pragma labtalk(2) //CPY 12/6/06 QA70-12736 LT_NEED_MORE_CNTRL_ON_ALLOWING_OC_FUNCS

int ThemeGallery()
{
	ThemeGalleryDlg themeDlg;
	
	int nRet = themeDlg.DoModalEx( GetWindow() );
	
	return 0;
}


